<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Input Config</title>
<link rel="stylesheet" type="text/css" href="../style/default.css" />
<script type="text/javascript" src="../js/browserdetect.js"></script>
<script type="text/javascript" src="../js/smsx_common.js"></script>
<script type="text/javascript" src="../js/system_10gbe_config.js"></script>
<style type="text/css">
	.body_width
	{
        width: 760px;
	}
    .tab_width
    {
        width: 740px;
    }
    .smallInput
	{
		width:97%;
		width:95%\9;
	}
	select
	{
		width: 100%;
	}
	.bigInput
	{
		width:99%;
		width:98%\9;
	}
</style>
</head>

<body>
<input type="hidden" id="language" value="0" />
<div class="body_div body_width">
    <div class="table_tab_div">
        <div class="table_tab_left"></div>
        <div class="table_tab tab_width">10GbE Input Configuration</div>
        <div class="table_tab_right"></div>
	</div>
	<div class="button_div">
		<div class="button_area">
			<input type="button" value="Apply" id="Apply" onClick="SetPortConfiguration();this.style.background = 'url(../images/btn2_normal.png)';"
			hidefocus="true" onMouseOver="mouseOverNormal(this);" onMouseOut="mouseOutNormal(this);" />
			<input type="button" value="Refresh" id="Reset" onClick="pageRefresh();this.style.background = 'url(../images/btn2_normal.png)';"
			hidefocus="true" onMouseOver="mouseOverNormal(this);" onMouseOut="mouseOutNormal(this);" />
		</div>
	</div>
	<div class="tableContainer">
		<table id="GbEInputPorts" cellpadding="0" cellspacing="0" width="100%">
			<thead>
		  	    <tr>
		    		<th>Port Configuration</th>
		    		<th>Port 1</th>
		     		<th>Port 2</th>
		  		</tr>
		  	</thead>
			<tbody>
			  	<tr>
					<th style="width:180px">IP Address</th>
					<td>
						<input id="Port1IP" maxlength="15" type="text" onKeyUp="EnableApply();" onChange="ValidateIP(this)" class="smallInput" />
					</td>
					<td>
						<input id="Port2IP" maxlength="15" type="text" onKeyUp="EnableApply();" onChange="ValidateIP(this)" class="smallInput" />
					</td>
				</tr>
				<tr>
					<th>Subnet Mask</th>
					<td>
						<input id="Port1Mask" maxlength="15" type="text" onKeyUp="EnableApply();" onChange="ValidateMask(this)" class="smallInput" />
					</td>
					<td>
						<input id="Port2Mask" maxlength="15" type="text" onKeyUp="EnableApply();" onChange="ValidateMask(this)" class="smallInput" />
					</td>
				</tr>
				<tr>
					<th>Gateway</th>
					<td>
						<input id="Port1Gateway" maxlength="15" type="text" onKeyUp="EnableApply();" onChange="ValidateGateway(this)" class="smallInput" />
					</td>
					<td>
						<input id="Port2Gateway" maxlength="15" type="text" onKeyUp="EnableApply();" onChange="ValidateGateway(this)" class="smallInput" />
					</td>
				</tr>
		 		<tr>
					<th>MAC Address</th>
					<td id="Port1MAC" style="text-align:left;padding-left:3px;"></td>
					<td id="Port2MAC" style="text-align:left;padding-left:3px;"></td>
				</tr>
		    	<tr>
		    		<th>Input Switch</th>
		    		<td>
		    			<select name="Port1InpSwitch" id="Port1InpSwitch" onChange="EnableApply();">
		    				<option value="1">On</option>
		    				<option value="0">Off</option>
		    			</select>
		    		</td>
		    		<td>
		    			<select name="Port2InpSwitch" id="Port2InpSwitch" onChange="EnableApply();">
		    				<option value="1">On</option>
		    				<option value="0">Off</option>
		    			</select>
		    		</td>
		    	</tr>
		    	<tr>
		    		<th>Speed Select</th>
		    		<td>
		    			<select name="Port1SpeedSelect" id="Port1SpeedSelect" onChange="EnableApply();">
			    			<option value="0" selected="selected">10Gbps Full</option>
                            <option value="1">1Gbps AN</option>
			    			<option value="2">1Gbps Full</option>
		    			</select>
		    		</td>
		    		<td>
		    			<select name="Port2SpeedSelect" id="Port2SpeedSelect" onChange="EnableApply();">
			    			<option value="0" selected="selected">10Gbps Full</option>
                            <option value="1">1Gbps AN</option>
			    			<option value="2">1Gbps Full</option>
		    			</select>
		    		</td>
		    	</tr>
		    	<tr>
		    		<th>Speed State</th>
		    		<td name="Port1SpeedState" id="Port1SpeedState" style="text-align:left;padding-left:3px;"></td>
		    		<td name="Port2SpeedState" id="Port2SpeedState" style="text-align:left;padding-left:3px;"></td>
		    	</tr>
		    	<tr>
		    		<th>GbE Input Name</th>
		    		<td>
		    			<input type="text" id="Port1InpName" maxlength="20" onKeyUp="EnableApply();" onChange="ValidateInpName(this)" class="smallInput" />
		    		</td>
		    		<td>
		    			<input type="text" id="Port2InpName" maxlength="20" onKeyUp="EnableApply();" onChange="ValidateInpName(this)" class="smallInput" />
		    		</td>
		    	</tr>
		    </tbody>
			<thead>
		 		<tr>
		    		<th>Port Pair Configuration</th>
		    		<th colspan="2"></th>
		    	</tr>
			</thead>
			<tbody>
				<tr>
					<th>Primary Port</th>
					<td colspan="2">
						<select id="Pair1PrimPort" onChange="EnableApply();" >
							<option value="0">1</option>
							<option value="1">2</option>
						</select>
					</td>
				</tr>
				<tr>
					<th>Current Active Port</th>
					<td colspan="2">
						<select id="Pair1ActPort" onChange="EnableApply();" >
							<option value="0">1</option>
							<option value="1">2</option>
						</select>
					</td>
				</tr>
				<tr>
					<th>Packet Format</th>
					<td colspan="2" style="text-align:left;">188</td>
				</tr>
			</tbody>
			<thead>
		 		<tr>
          <th>GbE Loop Out Cofiguration</th>
          <th colspan="2" id="gbeLoopSet"></th>
        </tr>
      </thead>
             <tbody>
        <tr>
          <th>Loop Out Switch</th>
          <td colspan="2">
            <select name="LoopOutSwitch" id="LoopOutSwitch" onchange="EnableApply();">
              <option value="1">On</option>
              <option value="0">Off</option>
            </select>
          </td>
        </tr>
        <tr>
          <th style="width:180px">IP Address</th>
          <td colspan="2">
            <input id="LoopOutIp" maxlength="15" type="text" onkeyup="EnableApply();" onchange="ValidateLoopIp(this)" class="smallInput" />
          </td>
        </tr>
        <tr>
          <th>MAC Address</th>
          <td colspan="2" id="LoopOutMac" style="text-align:left;padding-left:3px;"></td>
        </tr>
      </tbody>
			<thead>
		 		<tr>
		    		<th>Redundancy Configuration</th>
		    		<th colspan="2"></th>
		    	</tr>
			</thead>
			<tbody>
				<tr>
					<th>Backup Method</th>
					<td colspan="2">
						<select id="BackupMethod" onChange="CheckBackupMethod(this);EnableApply();" >
							<option value="1" selected>All Channel</option>
							<option value="0">1+1</option>
						</select>					
					</td>
				</tr>
				<tr>
					<th>Detention Mode of 1+1</th>
					<td colspan="2">
						<select id="DetMode" onChange="EnableApply();" >
							<option value="0">On Gbe Link Only</option>
		        			<option value="1">On Gbe Link With IP</option>
							<option value="2">On Gbe Link With UDP</option>
						</select>				
					</td>
				</tr>
				<tr>
					<th>Backup Enabled</th>
					<td colspan="2">
						<select id="BackupEnabled" onChange="CheckBackupEnabled(this);EnableApply();" >
		                    <option value="1">Enabled</option>
		                	<option value="0">Disabled</option>
		                </select>
					</td>
				</tr>
				<tr>
					<th>Check Time (100ms)</th>
					<td colspan="2">
						<input id="ChkTime" onKeyUp="EnableApply();" onChange="CheckTime(this);" maxlength="3" type="text" class="bigInput" />
					</td>
				</tr>
				<tr>
					<th>Revert To Primary</th>
					<td colspan="2">
						<select id="Rev2Prim" onChange="CheckRev2Primary(this);EnableApply();" >
							<option value="1">Enabled</option>
							<option value="0">Disabled</option>
						</select>
					</td>
				</tr>
				<tr>
					<th>Revert Check Time (100ms)</th>
					<td colspan="2">
						<input id="RevChkTime" onKeyUp="EnableApply();" onChange="CheckTime(this);" maxlength="3" type="text" class="bigInput" />
					</td>
				</tr>
				<tr>
					<th>Backup Mode</th>
					<td colspan="2">
						<select id="BackMode" onChange="EnableApply();" >
							<option value="0">Diffe Mode</option>
		        			<option value="1">Same Mode</option>
						</select>					
					</td>
				</tr>
			</tbody>
			<thead>
		 		<tr>
		    		<th>Gratuitous ARP</th>
		    		<th colspan="2"></th>
		    	</tr>
			</thead>
			<tbody>
				<tr>
					<th>Send Enabled</th>
					<td colspan="2">
						<select id="SendEnabled" onChange="CheckSendEnabled(this);EnableApply();" >
		                    <option value="1">Enabled</option>
		                	<option value="0">Disabled</option>
		                </select>
					</td>
				</tr>
				<tr>
					<th>Send Interval (s)</th>
					<td colspan="2">
						<input id="SendInterval" onKeyUp="EnableApply();" onChange="ValidateInterval(this);" maxlength="5" type="text" class="bigInput" />
					</td>
				</tr>
			</tbody>
			<thead>
		 		<tr>
		    		<th>IGMP Setting</th>
		    		<th colspan="4"></th>
		    	</tr>
			</thead>
			<tbody>
				<tr>
					<th>Send IGMP Version</th>
					<td colspan="4">
						<select id="IgmpVersion" onChange="EnableApply();" >
							<option value="0">No Sending</option>
							<option value="1">IGMP_V1</option>
							<option value="2">IGMP_V2</option>
							<option value="3">IGMP_V3</option>
		                </select>
					</td>
				</tr>
			</tbody>	
		  </table>
  </div>
  </div>
</body>
</html>
